/** !------------------------------------------------------------------------->
*
*  @file PduR_Cfg_generated.h
*
*  @creationDate 21 November 2024 16:54:49
*
*  @brief Generated PduR configuration header file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*!-------------------------------------------------------------------------->*/
#ifndef _PDUR_CFG_GENERATED_H_
#define _PDUR_CFG_GENERATED_H_

/*------------------------------------------------------------------------------------------------*\
  DEFINES
\*------------------------------------------------------------------------------------------------*/

/* Definition of all supported operation modes. */
#define PDUR_GATEWAY_OPERATION      STD_OFF
#define PDUR_COM_SUPPORT            STD_ON
#define PDUR_IPDUM_SUPPORT          STD_OFF
#define PDUR_SECOC_SUPPORT          STD_OFF
#define PDUR_J1939TP_SUPPORT        STD_OFF
#define PDUR_SD_SUPPORT             STD_OFF
#define PDUR_MULTICAST_TOIF_SUPPORT STD_OFF
#define PDUR_MULTICAST_TOTP_SUPPORT STD_OFF
#define PDUR_CANNM_SUPPORT          STD_OFF
#define PDUR_CANIF_SUPPORT          STD_ON
#define PDUR_LINIF_SUPPORT          STD_OFF
#define PDUR_SOAD_SUPPORT           STD_OFF
#define PDUR_DEV_ERROR_DETECT       STD_OFF
#define PDUR_ZERO_COST_OPERATION    STD_OFF

#define PDUR_MODULE_INIT_STRUCTURE \
{ \
    { \
        CanIf_Transmit, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0 \
    } ,  \
    { \
        0, \
        Com_TriggerTransmit, \
        0, \
        Com_RxIndication, \
        0, \
        0, \
        0, \
        0, \
        0 \
    }  \
}

#define PDUR_TARGET_MODULE_CANIF_10693_11337 0
#define PDUR_TARGET_MODULE_COM_10693_11337 1
#define PDUR_TARGET_MODULE_NONE 255

#define PDUR_TX_cmd_battery_pump_10693_11337 ((PduIdType) 0)
#define PDUR_TX_cmd_chiller_bypass_10693_11337 ((PduIdType) 1)
#define PDUR_TX_cmd_comp_10693_11337 ((PduIdType) 2)
#define PDUR_TX_cmd_fan_10693_11337 ((PduIdType) 3)
#define PDUR_TX_cmd_heater_10693_11337 ((PduIdType) 4)
#define PDUR_TX_cmd_motor_pump_10693_11337 ((PduIdType) 5)
#define PDUR_TX_cmd_parallel_serial_10693_11337 ((PduIdType) 6)
#define PDUR_TX_cmd_rad_bypass_10693_11337 ((PduIdType) 7)
#define PDUR_TX_I_traction_10693_11337 ((PduIdType) 8)
#define PDUR_TX_Q_charger_10693_11337 ((PduIdType) 9)
#define PDUR_TX_Q_dcdc_10693_11337 ((PduIdType) 10)
#define PDUR_TX_Q_inverter_10693_11337 ((PduIdType) 11)
#define PDUR_TX_Q_motor_10693_11337 ((PduIdType) 12)
#define PDUR_TX_v_vehicle_10693_11337 ((PduIdType) 13)

#define PDUR_NUM_TX_PATHS 14


#define PDUR_TX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_battery_pump_11216_10693_11337 \
        }, \
        1, \
        0, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_chiller_bypass_11215_10693_11337 \
        }, \
        1, \
        1, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_comp_11214_10693_11337 \
        }, \
        1, \
        2, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_fan_11213_10693_11337 \
        }, \
        1, \
        3, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_heater_11212_10693_11337 \
        }, \
        1, \
        4, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_motor_pump_11211_10693_11337 \
        }, \
        1, \
        5, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_parallel_serial_11210_10693_11337 \
        }, \
        1, \
        6, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_cmd_rad_bypass_11209_10693_11337 \
        }, \
        1, \
        7, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_I_traction_11206_10693_11337 \
        }, \
        1, \
        8, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_Q_charger_11202_10693_11337 \
        }, \
        1, \
        9, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_Q_dcdc_11201_10693_11337 \
        }, \
        1, \
        10, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_Q_inverter_11200_10693_11337 \
        }, \
        1, \
        11, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_Q_motor_11199_10693_11337 \
        }, \
        1, \
        12, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337, \
            Com_TX_v_vehicle_11189_10693_11337 \
        }, \
        1, \
        13, \
    }  \
}

#define PDUR_TX_ENDPOINTS \
{ \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_battery_pump_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_chiller_bypass_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_comp_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_fan_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_heater_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_motor_pump_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_parallel_serial_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_cmd_rad_bypass_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_I_traction_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_Q_charger_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_Q_dcdc_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_Q_inverter_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_Q_motor_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10693_11337, \
        CanIf_ThermalCANcomplete_v_vehicle_FrameTrig \
    }  \
}



/* Mapping of Interface RX_INDICATION PDU IDs to RX_INDICATION table entries */
#define PDUR_RX_AngVel_Compressor_10693_11337_CanIf_Com ((PduIdType) 0)
#define PDUR_RX_EPower_Compressor_10693_11337_CanIf_Com ((PduIdType) 1)
#define PDUR_RX_i_battery_10693_11337_CanIf_Com ((PduIdType) 2)
#define PDUR_RX_p_chiller_10693_11337_CanIf_Com ((PduIdType) 3)
#define PDUR_RX_p_cond_10693_11337_CanIf_Com ((PduIdType) 4)
#define PDUR_RX_PJoule_battery_10693_11337_CanIf_Com ((PduIdType) 5)
#define PDUR_RX_T_battery1_10693_11337_CanIf_Com ((PduIdType) 6)
#define PDUR_RX_T_battery2_10693_11337_CanIf_Com ((PduIdType) 7)
#define PDUR_RX_T_battery3_10693_11337_CanIf_Com ((PduIdType) 8)
#define PDUR_RX_T_battery4_10693_11337_CanIf_Com ((PduIdType) 9)
#define PDUR_RX_T_coolant_battery_in_10693_11337_CanIf_Com ((PduIdType) 10)
#define PDUR_RX_T_coolant_inverter_out_10693_11337_CanIf_Com ((PduIdType) 11)
#define PDUR_RX_T_inverter_10693_11337_CanIf_Com ((PduIdType) 12)
#define PDUR_RX_T_motor_10693_11337_CanIf_Com ((PduIdType) 13)
#define PDUR_RX_Torque_Compressor_10693_11337_CanIf_Com ((PduIdType) 14)
#ifndef PDUR_RX_PDUID_NONE
#define PDUR_RX_PDUID_NONE ((PduIdType) -1)
#endif
#define PDUR_NUM_RX_PATHS 15

/* Rx routing table definition. */
#define PDUR_RX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_AngVel_Compressor_11217_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_EPower_Compressor_11208_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_i_battery_11207_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_p_chiller_11205_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_p_cond_11204_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_PJoule_battery_11203_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_battery1_11198_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_battery2_11197_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_battery3_11196_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_battery4_11195_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_coolant_battery_in_11194_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_coolant_inverter_out_11193_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_inverter_11192_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_T_motor_11191_10693_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10693_11337,\
            Com_RX_Torque_Compressor_11190_10693_11337 \
        } \
    }  \
}
#endif /* _PDUR_CFG_GENERATED_H_ */

